version 13 // indicates version 
cls // clears backscroll display buffer
clear all // "start from scratch"
set more off // suppresses -more- prompts

/* load data */
cd "C:\Users\benja\Dropbox\BenjaminWork\ResearchProject\data\creation\data-sets and merge\survey attitude scale\recode"
use "Survey attitude scale.dta"

/* check for no duplicate entries */
bys nomem_encr: gen N = _N
assert N == 1
drop N // no duplicate entries
// individuals are nested in households, but this is ignored here 

/* rename variables */
rename nomem_encr id

rename *cp08?(###)* .?(#)*
rename *cp09?(###)* .?(#)*
rename *cp10?(###)* .?(#)*
rename *cp11?(###)* .?(#)*
rename *cp12?(###)* .?(#)*
rename *cp13?(###)* .?(#)*
drop *cp14* // last wave has no observation

local k = 8
qui foreach letter in a b c d e f {
	// for each wave separately 
	local i = 1
	foreach j in 1 2 3 {
		// take these items and rename them ...
		rename `letter'`j' joy`i'`k'
		local i = `i' + 1
	}
	local i = 1 // countervariable has to be set to 1 each time
	foreach j in 4 5 6 {
		rename `letter'`j' val`i'`k'
		replace val`i'`k' = 8 - val`i'`k' if `i' == 3 // label of val3? is not correct anymore
		local i = `i' + 1
	}
	local i = 1
	foreach j in 7 8 9 {
		rename `letter'`j' bur`i'`k'
		local i = `i' + 1
	}
	local k = `k' + 1
}

/* create mean score */
qui forvalues j = 8/13 {

	// Survey Enjoyment //
	egen joynonmiss`j' = rownonmiss(joy1`j' joy2`j' joy3`j') // number of nonmissing values
	gen joyscore`j' = .
	regen joyscore`j'  = rowmean(joy1`j' joy2`j' joy3`j') if joynonmiss`j' >= 2, replace // create mean score if at least 2 observations
	// at least 2 obs. have to be available to create a mean score
	
	// Survey Value //
	egen valnonmiss`j' = rownonmiss(val1`j' val2`j' val3`j') // number of nonmissing values
	gen valscore`j' = .
	regen valscore`j'  = rowmean(val1`j' val2`j' val3`j') if valnonmiss`j' >= 2, replace // create mean score if at least 2 observations
	
	// Survey Burden //
	egen burnonmiss`j' = rownonmiss(bur1`j' bur2`j' bur3`j') // number of nonmissing values
	gen burscore`j' = .
	regen burscore`j'  = rowmean(bur1`j' bur2`j' bur3`j') if burnonmiss`j' >= 2, replace // create mean score if at least 2 observations
	// at least 2 obs. have to be available to create a mean score
	
}

/* Example statistics for the created scores */   
alpha joy18 joy28 joy38, item
corr joyscore8 joy18 joy28 joy38

alpha val18 val28 val38, item
corr valscore8 val18 val28 val38

alpha bur18 bur28 bur38, item
corr burscore8 bur18 bur28 bur38

/* creation of data sets */
keep(id *score*)

////////////////////// WIDE /////////////////////////////////
stata2mplus using sas, replace
/////////////////////////////////////////////////////////////

////////////////////// LONG /////////////////////////////////
reshape long joyscore valscore burscore, i(id) j(wave) 
stata2mplus using sasLong, replace
/////////////////////////////////////////////////////////////

label var joyscore "Survey Enjoyment (1=totally dis-,7=agree)" 
label var valscore "Survey Value (1=totally dis-,7=agree)" 
label var burscore "Survey Burden (1=totally dis-,7=agree)"

////////////// STATA FILE FOR MERGING ///////////////////////
saveold d11_sas, replace
/////////////////////////////////////////////////////////////

